import messaging from '@react-native-firebase/messaging';
import Utils from "../Utils";

import { Platform } from "react-native";

class Notification {
    hasPermission = async callback => {
        try {
            const authStatus = await messaging().requestPermission();
            const enabled =
                authStatus === messaging.AuthorizationStatus.AUTHORIZED ||
                authStatus === messaging.AuthorizationStatus.PROVISIONAL;

            callback(enabled);
        } catch (error) {
            console.error('Error checking notification permission:', error);
            callback(false);
        }
    };

    notificationPermission = async () => {
        try {
            // Request permission - this will check and request if needed
            const authStatus = await messaging().requestPermission();
            const granted =
                authStatus === messaging.AuthorizationStatus.AUTHORIZED ||
                authStatus === messaging.AuthorizationStatus.PROVISIONAL;

            return granted;
        } catch (error) {
            console.error('Error requesting notification permission:', error);
            // Return true as fallback to allow app to continue
            return true;
        }
    };

    fcmToken = async callback => {
        try {
            console.log('Attempting to get FCM token...');
            const fcmToken = await messaging().getToken();

            if (fcmToken) {
                console.log('FCM token retrieved successfully');
                // user has a device token
                callback(fcmToken);
            } else {
                console.log('No FCM token available, using fallback');
                // user doesn't have a device token yet, use a fallback
                callback('no-token-available');
            }
        } catch (error) {
            console.error('Error getting FCM token:', error);
            // Always call callback even if there's an error, otherwise login will hang
            callback('no-token-available');
        }
    };

    // works from kill state to foreground state
    notificationInitialize = callback => {
        messaging()
            .getInitialNotification()
            .then((notificationOpen) => {
                if (notificationOpen) {
                    callback(notificationOpen);
                }
            })
            .catch(error => {
                console.error('Error getting initial notification:', error);
                // Don't pass error to callback, just log it
            });
    };

    onNotificationOpened = callback => {
        
        messaging().onNotificationOpenedApp(remoteMessage => {
          
            callback(remoteMessage);
          });
        
    };

    notificationForeground = callback => {

        messaging().onMessage(async remoteMessage => {
            callback(remoteMessage)

          });
          
    };

    notificationBackground = callback => {

        messaging().setBackgroundMessageHandler(async remoteMessage => {

            callback(remoteMessage)
            
          });
    }

}
export default new Notification();
