import {
    NOTIFICATION_REQUEST_ACCEPTED,
    NOTIFICATION_ADD_REQUEST,
    // PRODUCT_TYPE_ID_RENT
} from "../constants";
import { push } from "./NavigationService";
import Utils from "../Utils";

const handleDirectingToScreen = (directionFunc, message) => {
    if (Utils.getIsUserLoggedIn()) {
        directionFunc();
    } else {
        Utils.showMessage("Alert", message);
    }
};

export const helperOnNotificationInitialized = (notificationObj, callBack) => {

    if (Utils.isPlatformAndroid()) {
        const parsedCustomData = JSON.parse(notificationObj._data.custom_data);
        callBack(
            parsedCustomData.contract_id,
            parsedCustomData.identifier,
            parsedCustomData.invitation_id
        );
    } else {
        const { _data } = notificationObj;

        let data = JSON.parse(_data["gcm.notification.custom_data"]);
        callBack(data.contract_id, data.identifier, data.invitation_id);
    }
};

export const helperOnNotificationOpened = (notificationObj, callBack) => {
  
  //  {"collapseKey": "com.medicashifts", "data": {"custom_data": "{\"identifier\":\"contractor_invitation\",\"invitation_id\":700881,\"contract_id\":22350,\"title\":\"dev\",\"message\":\"Has sent you a contract invitation.\"}", "identifier": "contract_invitation_create", "message": "{\"sound\":\"default\",\"body\":\"Has sent you a contract invitation.\"}", "user_badge": "0"}, "from": "628442394809", "messageId": "0:1666947962734994%7b9e7c797b9e7c79", "notification": {"android": {"sound": "default"}, "body": "Has sent you a contract invitation."}, "sentTime": 1666947962642, "ttl": 2419200}
    if (Utils.isPlatformAndroid()) {
        const parsedCustomData = JSON.parse(notificationObj.data.custom_data);
        callBack(
            parsedCustomData.contract_id,
            parsedCustomData.identifier,
            parsedCustomData.invitation_id
        );
    } else {
        const { _data } = notificationObj;
        callBack(_data.contract_id, _data.identifier, _data.invitation_id);
    }
};

export const helperOnNotificationForeground = (notificationObj) => {
};
