import React, { Component } from "react";
import { connect } from "react-redux";
import { WithFetching, WithNetInfoListener } from "../HOC";
import {
    View,
    Text,
    ImageBackground,
    TouchableOpacity,
    Platform
} from "react-native";
import { NetInfoModal, AppButton, FormHandler, Input,Supporticon } from "../components";
import { pop, push, popToTop } from "../services/NavigationService";
import { Images, icons, UIFont, colors } from "../assets";
import { INPUT_TYPES } from "../components/FormHandler/Constants";
import {
    API_LOGIN,
    API_CATEGORIES_LIST,
    CHECK_SOCIAL_LOGIN,
    API_SIGN_UP_FACILITY,
    API_SIGN_UP_CONTRACTOR,
    API_INFO_CONTENT
} from "../services/WebService";
import { generalAction, generalSaveAction } from "../actions/GeneralActions";
import { USER, CATEGORIES, INFO_CONTENT } from "../actions/ActionTypes";
//import Notification from "../../services/Notification";
import Utils from "../Utils";
import SocialLogin from "../containers/SocialLogin";
import styles from "./styles";

class testdev extends Component {
    state = {
        email: ""
    };

    componentDidMount() {

        this.callStaticData(
            API_CATEGORIES_LIST,
            CATEGORIES.SUCCESS,
            CATEGORIES.FAILURE
        );
        this.callStaticData(
            API_INFO_CONTENT,
            INFO_CONTENT.SUCCESS,
            INFO_CONTENT.FAILURE
        );
    }

    callStaticData(api, success, failure) {
        this.props.generalAction(
            api,
            {},
            success,
            failure,
            undefined,
            undefined,
            true
        );
    }

    onSubmit = () => {
        const formData = this.formHandlerUser.onSubmitForm();
        formData && this.loginRequest(formData);
    };

    // loginRequest = formData => {
    //     Notification.fcmToken(token => {
    //         let payload = new FormData();
    //         payload.append("email", formData.email);
    //         payload.append("password", formData.password);
    //         payload.append(
    //             "device_type",
    //             Utils.isPlatformAndroid() ? "android" : "ios"
    //         );
    //         payload.append("device_token", token);
    //         this.props.generalAction(
    //             API_LOGIN,
    //             payload,
    //             USER.SUCCESS,
    //             USER.FAILURE,
    //             this.onLoginSuccess,
    //             this.onLoginFailure
    //         );

    //         this.props.cbShowLoader(true);
    //     });
    // };

    // socialLogin = ({ user }) => {
    //     Notification.fcmToken(token => {
    //         let payload = new FormData();
    //         payload.append("full_name", user.name);
    //         payload.append("email", user.email);
    //         payload.append("social_id", user.id);
    //         payload.append("social_type", user.social_type);
    //         payload.append("device_token", token);
    //         payload.append("device_type", Utils.getDeviceType());

    //         this.props.cbShowLoader(true);
    //         this.props.generalAction(
    //             CHECK_SOCIAL_LOGIN,
    //             payload,
    //             USER.SUCCESS,
    //             USER.FAILURE,
    //             data => {
    //                 this.props.cbShowLoader(false);
    //                 this.setState({ user: payload });
    //                 if (typeof data && data.length == 0) {
    //                     push("userType", {
    //                         cbOnSelectUser: this.cbOnSelectUser,
    //                         selectUser: true
    //                     });
    //                 } else {
    //                     this.onLoginSuccess(data);
    //                 }
    //             },
    //             this.onLoginFailure
    //         );
    //     });
    // };

    cbOnSelectUser = userType => {
        let { user } = this.state;
        user.append("user_type", userType);
        this.props.cbShowLoader(true);
        let api =
            userType === "Contractor"
                ? API_SIGN_UP_CONTRACTOR
                : API_SIGN_UP_FACILITY;
        this.props.generalAction(
            api,
            user,
            USER.SUCCESS,
            USER.FAILURE,
            this.onLoginSuccess,
            this.onLoginFailure
        );
    };

    onLoginSuccess = user => {
        Utils.setUserLoggedIn(true);
        Utils.setUserToken(user.token);
        console.log("TOKENAUTH",user.token);
        Utils.setUserType(user.user_type);
        this.props.cbShowLoader(false);
        push(
            user.user_type === "Facility" ? "facilityStack" : "contractorStack",
            {
                user
            }
        );

       

    };

    onLoginFailure = err => {
        this.props.cbShowLoader(false);

        var step1 = err.step1;
        var step2 = err.step2;
        var step3 = err.step3;
        var step4 = err.step4;

        if(step1 == "f"){

        }
        else if(step2 == "f"){

            push("professionalDetails");

        }
        else if(step3 == "f"){

            push("documentRegister");

        }else if(step4 == "f"){

            push("bankDetails");

        }
        else{

            Utils.showError(err);

        }

    };

    CardGap = obj => <View style={obj} />;

    loginCard = () => {
        return (
            <View elevation={15} style={styles.inputWrapper}>
                <FormHandler ref={ref => (this.formHandlerUser = ref)}>
                    <Input
                        placeholder="Email"
                        error="Email is required"
                        type={INPUT_TYPES.EMAIL}
                        identifier="email"
                        blurOnSubmit={false}
                        // value={"jacob@yopmail.com"}
                        textFieldStyle={[styles.emailAddressTextField]}
                        rightTextFieldImage={icons.email}
                    />
                    <Input
                        placeholder="Password"
                        error="Password is required"
                        type={INPUT_TYPES.PASSWORD}
                        identifier="password"
                        blurOnSubmit
                        textFieldStyle={[styles.emailAddressTextField]}
                        rightTextFieldImage={icons.key}
                        // value={"123456"}
                    />
                </FormHandler>
                <AppButton
                    buttonTitle="Log In"
                    style={{
                        backgroundColor: colors.ActiveTabTitle,
                        marginTop: 20,
                        width: "100%"
                    }}
                    btnColor={colors.cardColor}
                    onPress={() => {
                        this.onSubmit();
                    }}
                />

                <SocialLogin
                    socialLogin={this.socialLogin}
                    cbShowLoader={this.props.cbShowLoader}
                />
            </View>
        );
    };

    heading() {
        return (
            <React.Fragment>
                <View style={{ flexDirection: "row", alignSelf: "flex-start" }}>
                    <Text style={[styles.heading, styles.boldHeading]}>
                        Login
                    </Text>
                    <Text style={styles.heading}> with your</Text>
                </View>
                <Text style={[styles.heading, { marginLeft: 25 }]}>email</Text>
            </React.Fragment>
        );
    }

    footer() {
        return (
            <React.Fragment>
                <TouchableOpacity onPress={() => push("forgotPassword")}>
                    <Text style={styles.bottomText}>Forgot your password?</Text>
                </TouchableOpacity>
                <TouchableOpacity
                    style={{ marginTop: 8 }}
                    onPress={() => push("userType")}
                >
                    <Text style={styles.bottomText}>
                        Don't have an account yet?{" "}
                        <Text style={[styles.bottomText, styles.registerText]}>
                            Register
                        </Text>
                    </Text>
                </TouchableOpacity>
            </React.Fragment>
        );
    }

    render() {
        const { isNetworkConnected } = this.props.networkInfo;
        const { generalAction, cbShowLoader } = this.props;

        return (
            <ImageBackground source={Images.bgImage} style={styles.bgImage}>
                {this.CardGap(styles.divForUpperSpace)}
                {this.heading()}
                {this.CardGap(styles.divForMidSpace)}
                {this.loginCard()}
                {this.CardGap(styles.divForBottomSpace)}

                {this.CardGap(styles.divForAnotherSpace)}
                {this.footer()}
                {this.CardGap(styles.divForBottomSpace)}
                <NetInfoModal isNetworkConnected={isNetworkConnected} />

                <Supporticon
                 clickBtn={() =>push("SupportLogin")}/>
            </ImageBackground>
        );
    }
}

const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ networkInfo }) => ({ networkInfo });

export default connect(
    mapStateToProps,
    actions
)(WithFetching(WithNetInfoListener(testdev)));
